#version 330 compatibility




/*
 _______ _________ _______  _______  _ 
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _ 
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/





in vec4 texcoord;

in vec3 colorSunlight;
in vec3 colorSkylight;
in vec3 colorTorchlight;
in vec3 colorSkyUp;

in vec4 skySHR;
in vec4 skySHG;
in vec4 skySHB;

in vec3 worldLightVector;
in vec3 worldSunVector;

out float timeMidnight;

#include "lib/Uniforms.inc"
#include "lib/Common.inc"



/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////








vec2 GetNearFragment(vec2 coord, float depth, out float minDepth)
{
	
	
	vec2 texel = 1.0 / vec2(viewWidth, viewHeight);
	vec4 depthSamples;
	depthSamples.x = texture2D(depthtex1, coord + texel * vec2(1.0, 1.0)).x;
	depthSamples.y = texture2D(depthtex1, coord + texel * vec2(1.0, -1.0)).x;
	depthSamples.z = texture2D(depthtex1, coord + texel * vec2(-1.0, 1.0)).x;
	depthSamples.w = texture2D(depthtex1, coord + texel * vec2(-1.0, -1.0)).x;

	vec2 targetFragment = vec2(0.0, 0.0);

	if (depthSamples.x < depth)
		targetFragment = vec2(1.0, 1.0);
	if (depthSamples.y < depth)
		targetFragment = vec2(1.0, -1.0);
	if (depthSamples.z < depth)
		targetFragment = vec2(-1.0, 1.0);
	if (depthSamples.w < depth)
		targetFragment = vec2(-1.0, -1.0);


	minDepth = min(min(min(depthSamples.x, depthSamples.y), depthSamples.z), depthSamples.w);

	return coord + texel * targetFragment;
}






#include "lib/Materials.inc"
#include "lib/GBufferData.inc"




 int v(float v)
 {
   return int(floor(v));
 }
 int t(int f)
 {
   return f-v(mod(float(f),2.))-0;
 }
 int e(int f)
 {
   return f-v(mod(float(f),2.))-1;
 }
 int e()
 {
   ivec2 s=ivec2(viewWidth,viewHeight);
   int f=s.x*s.y;
   return t(v(floor(pow(float(f),.333333))));
 }
 int t()
 {
   ivec2 s=ivec2(2048,2048);
   int f=s.x*s.y;
   return e(v(floor(pow(float(f),.333333))));
 }
 vec3 f(vec2 v)
 {
   ivec2 f=ivec2(viewWidth,viewHeight);
   int z=f.x*f.y,y=e();
   ivec2 d=ivec2(v.x*f.x,v.y*f.y);
   float x=float(d.y/y),i=float(int(d.x+mod(f.x*x,y))/y);
   i+=floor(f.x*x/y);
   vec3 s=vec3(0.,0.,i);
   s.x=mod(d.x+mod(f.x*x,y),y);
   s.y=mod(d.y,y);
   s.xyz=floor(s.xyz);
   s/=y;
   s.xyz=s.xzy;
   return s;
 }
 vec2 d(vec3 v)
 {
   ivec2 f=ivec2(viewWidth,viewHeight);
   int z=e();
   vec3 s=v.xzy*z;
   s=floor(s+1e-05);
   float x=s.z;
   vec2 r;
   r.x=mod(s.x+x*z,f.x);
   float i=s.x+x*z;
   r.y=s.y+floor(i/f.x)*z;
   r+=.5;
   r/=f;
   return r;
 }
 vec3 x(vec2 v)
 {
   vec2 f=v;
   f.xy/=.5;
   ivec2 s=ivec2(2048,2048);
   int z=s.x*s.y,y=t();
   ivec2 d=ivec2(f.x*s.x,f.y*s.y);
   float x=float(d.y/y),i=float(int(d.x+mod(s.x*x,y))/y);
   i+=floor(s.x*x/y);
   vec3 r=vec3(0.,0.,i);
   r.x=mod(d.x+mod(s.x*x,y),y);
   r.y=mod(d.y,y);
   r.xyz=floor(r.xyz);
   r/=y;
   r.xyz=r.xzy;
   return r;
 }
 vec2 d(vec3 v,int y)
 {
   v=clamp(v,vec3(0.),vec3(1.));
   ivec2 f=ivec2(2048,2048);
   vec3 s=v.xzy*y;
   s=floor(s+1e-05);
   float x=s.z;
   vec2 r;
   r.x=mod(s.x+x*y,f.x);
   float i=s.x+x*y;
   r.y=s.y+floor(i/f.x)*y;
   r+=.5;
   r/=f;
   r.xy*=.5;
   return r;
 }
 vec3 e(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v=clamp(v,vec3(0.),vec3(1.)),v;
 }
 vec3 f(vec3 v,int y)
 {
   return v*=1./y,v=v+vec3(.5),v;
 }
 vec3 s(vec3 v)
 {
   int s=t();
   v=v-vec3(.5);
   v*=s;
   return v;
 }
 vec3 r(vec3 v)
 {
   int y=e();
   v*=1./y;
   v=v+vec3(.5);
   v=clamp(v,vec3(0.),vec3(1.));
   return v;
 }
 vec3 h(vec3 v)
 {
   int s=e();
   v=v-vec3(.5);
   v*=s;
   return v;
 }
 vec3 d()
 {
   vec3 v=cameraPosition.xyz+.5,f=previousCameraPosition.xyz+.5,i=floor(v-.0001),y=floor(f-.0001);
   return i-y;
 }
 vec3 n(vec3 v)
 {
   vec4 f=vec4(v,1.);
   f=shadowModelView*f;
   f=shadowProjection*f;
   f/=f.w;
   float x=sqrt(f.x*f.x+f.y*f.y),y=1.f-SHADOW_MAP_BIAS+x*SHADOW_MAP_BIAS;
   f.xy*=.95f/y;
   f.z=mix(f.z,.5,.8);
   f=f*.5f+.5f;
   f.xy*=.5;
   f.xy+=.5;
   return f.xyz;
 }
 vec3 d(vec3 v,vec3 f,vec3 y,vec3 x,int z)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 s=n(v);
   float t=.5;
   vec3 i=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z-.0006*t),0).x;
   i*=saturate(dot(f,y));
   {
     vec4 d=texture2DLod(shadowcolor1,s.xy-vec2(0.,.5),4);
     float r=abs(d.x*256.-(v.y+cameraPosition.y)),h=GetCausticsComposite(v,f,r),w=shadow2DLod(shadowtex0,vec3(s.xy-vec2(0.,.5),s.z+1e-06),4).x;
     i=mix(i,i*h,1.-w);
   }
   i=TintUnderwaterDepth(i);
   return i*(1.-rainStrength);
 }
 vec3 e(vec3 v,vec3 f,vec3 y,vec3 x,int z)
 {
   if(rainStrength>.99)
     return vec3(0.);
   vec3 i=s(v),d=n(i+y*.99);
   float t=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(d.xy,d.z-.0006*t),3).x;
   r*=saturate(dot(f,y));
   r=TintUnderwaterDepth(r);
   return r*(1.-rainStrength);
 }
 vec3 f(vec3 v,vec3 f,vec3 y,vec3 x,int z)
 {
   if(rainStrength>.99)
     return vec3(0.);
   v+=1.;
   v-=Fract01(cameraPosition+.5);
   vec3 s=n(v);
   float t=.5;
   vec3 r=vec3(1.)*shadow2DLod(shadowtex0,vec3(s.xy,s.z-.0006*t),2).x;
   r*=saturate(dot(f,y));
   r=TintUnderwaterDepth(r);
   return r*(1.-rainStrength);
 }struct GITemporalData2{float cNuyPQlxuC;float ZFucbkcOTp;float vfyvrzqkzI;float xSSGSkZnBe;vec3 MXlHQOttjo;};
 vec4 w(GITemporalData2 v)
 {
   vec4 f;
   v.MXlHQOttjo=max(vec3(0.),v.MXlHQOttjo);
   f.x=v.cNuyPQlxuC;
   v.MXlHQOttjo=pow(v.MXlHQOttjo,vec3(.25));
   f.y=PackTwo16BitTo32Bit(v.MXlHQOttjo.x,v.vfyvrzqkzI);
   f.z=PackTwo16BitTo32Bit(v.MXlHQOttjo.y,v.xSSGSkZnBe);
   f.w=PackTwo16BitTo32Bit(v.MXlHQOttjo.z,v.ZFucbkcOTp);
   return f;
 }
 GITemporalData2 p(vec4 v)
 {
   GITemporalData2 f;
   vec2 s=UnpackTwo16BitFrom32Bit(v.y),i=UnpackTwo16BitFrom32Bit(v.z),n=UnpackTwo16BitFrom32Bit(v.w);
   f.cNuyPQlxuC=v.x;
   f.vfyvrzqkzI=s.y;
   f.xSSGSkZnBe=i.y;
   f.ZFucbkcOTp=n.y;
   f.MXlHQOttjo=pow(vec3(s.x,i.x,n.x),vec3(4.));
   return f;
 }
 GITemporalData2 m(vec2 v)
 {
   vec2 f=1./vec2(viewWidth,viewHeight),y=vec2(viewWidth,viewHeight);
   v=(floor(v*y)+.5)*f;
   return p(texture2DLod(colortex5,v,0));
 }
 float h(float v,float y)
 {
   float f=1.;
   #ifdef FULL_RT_REFLECTIONS
   f=clamp(pow(v,.125)+y,0.,1.);
   #else
   f=clamp(v*10.-7.,0.,1.);
   #endif
   return f;
 }
 void d(inout float v,inout float f,float y,float i,vec3 s,float z)
 {
   v*=mix(2.4,2.4,i);
   float x=dot(s,vec3(1.));
   f*=1.-pow(i,.4);
   f/=y*.1+2e-06;
   f*=4.;
   f*=.6;
   float r=y/(x+1e-07)*.2+4e-08;
   r=min(r,1.);
   r=mix(r,1.,pow(i,.25));
   if(z<.12)
     f=0.;
 }
 float d(vec3 v,vec3 y,float f)
 {
   float r=dot(abs(v-y),vec3(.3333));
   r*=f;
   r*=.18;
   return r;
 }
 void e(inout vec3 v,vec2 f,vec3 y)
 {}
 float m(float v,float f)
 {
   return v/(f*20.01+1.);
 }struct Ray{vec3 dir;vec3 origin;};struct BBRay{vec3 origin;vec3 direction;vec3 inv_direction;ivec3 sign;};
 BBRay n(vec3 v,vec3 y)
 {
   vec3 f=vec3(1.)/y;
   return BBRay(v,y,f,ivec3(f.x<0?1:0,f.y<0?1:0,f.z<0?1:0));
 }
 void d(in BBRay v,in vec3 f[2],out float r,out float y)
 {
   float i,z,x,s;
   r=(f[v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   y=(f[1-v.sign[0]].x-v.origin.x)*v.inv_direction.x;
   i=(f[v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   z=(f[1-v.sign[1]].y-v.origin.y)*v.inv_direction.y;
   x=(f[v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   s=(f[1-v.sign[2]].z-v.origin.z)*v.inv_direction.z;
   r=max(max(r,i),x);
   y=min(min(y,z),s);
 }
 vec2 g(inout float v)
 {
   return fract(sin(vec2(v+=.1,v+=.1))*vec2(43758.5,22578.1));
 }
 vec3 i(vec2 v)
 {
   vec2 f=vec2(v.xy*vec2(viewWidth,viewHeight))/64.;
   const vec2 s[16]=vec2[16](vec2(-1,-1),vec2(0,-.333333),vec2(-.5,.333333),vec2(.5,-.777778),vec2(-.75,-.111111),vec2(.25,.555556),vec2(-.25,-.555556),vec2(.75,.111111),vec2(-.875,.777778),vec2(.125,-.925926),vec2(-.375,-.259259),vec2(.625,.407407),vec2(-.625,-.703704),vec2(.375,-.037037),vec2(-.125,.62963),vec2(.875,-.481482));
   if(v.x<2./viewWidth||v.x>1.-2./viewWidth||v.y<2./viewHeight||v.y>1.-2./viewHeight)
     ;
   else
      f+=s[int(mod(frameCounter,4.))]*.5;
   f=(floor(f*64.)+.5)/64.;
   vec3 y=texture2D(noisetex,f).xyz;
   return y;
 }
 vec3 f(vec3 v,inout float f,int y)
 {
   vec2 s=i(texcoord.xy+vec2(f+=.1,f+=.1)).xy;
   s=fract(s+g(f)*.1);
   float z=6.28319*s.x,x=sqrt(s.y);
   vec3 r=normalize(cross(v,vec3(0.,1.,1.))),w=cross(v,r),t=r*cos(z)*x+w*sin(z)*x+v.xyz*sqrt(1.-s.y);
   return t;
 }
 vec3 g(vec3 v,vec3 y)
 {
   vec2 f=d(r(s(v)+y+1.));
   vec3 z=m(f).MXlHQOttjo;
   return z;
 }
 vec3 f()
 {
   vec2 v=d(f(texcoord.xy)+d()/e());
   vec3 y=m(v).MXlHQOttjo;
   return y;
 }
 bool i(ivec3 v,BBRay f)
 {
   vec3 y=vec3(v),z=vec3(v)+1.,i=mix(y,z,vec3(.5));
   float s=mix(.25,0.,saturate(distance(f.origin,i)*.5-1.));
   vec3 x[2]=vec3[2](mix(y,z,vec3(s)),mix(y,z,vec3(1.-s)));
   float r,t;
   d(f,x,r,t);
   return r<=t;
 }
 vec3 e(float v,float f,float y,vec3 s)
 {
   vec3 r;
   r.x=y*cos(v);
   r.y=y*sin(v);
   r.z=f;
   vec3 z=abs(s.y)<.999?vec3(0,0,1):vec3(1,0,0),i=normalize(cross(s,vec3(0.,1.,1.))),x=cross(i,s);
   return i*r.x+x*r.y+s*r.z;
 }
 vec3 g(vec2 v,float f,vec3 y)
 {
   float s=2*3.14159*v.x,z=sqrt((1-v.y)/(1+(f*f-1)*v.y)),i=sqrt(1-z*z);
   return e(s,z,i,y);
 }
 float G(float v)
 {
   return 2./(v*v+1e-07)-2.;
 }
 vec3 G(in vec2 v,in float f,in vec3 y)
 {
   float s=G(f),i=2*3.14159*v.x,z=pow(v.y,1.f/(s+1.f)),x=sqrt(1-z*z);
   return e(i,z,x,y);
 }
 float G(float v,float y)
 {
   return 1./(v*(1.-y)+y);
 }
 void p(inout vec3 v,in vec3 f)
 {
   vec3 y=normalize(f.xyz),i=v;
   float s=dot(i,y);
   i=normalize(v-y*saturate(s)*.5);
   v=i;
 }
 vec4 B(in vec2 v)
 {
   float f=GetDepth(v);
   vec4 s=gbufferProjectionInverse*vec4(v.x*2.f-1.f,v.y*2.f-1.f,2.f*f-1.f,1.f);
   s/=s.w;
   return s;
 }
 vec4 B(in vec2 v,in float y)
 {
   vec4 f=gbufferProjectionInverse*vec4(v.x*2.f-1.f,v.y*2.f-1.f,2.f*y-1.f,1.f);
   f/=f.w;
   return f;
 }
 void B(inout vec3 v,in vec3 f,in vec3 y,vec3 s,float z)
 {
   float r=length(f);
   #ifdef FADE_TO_ATMOSPHERE
   float i=length(f)/far;
   i=pow(i,6.)*.07+pow(i,2.)*.003;
   #else
   float x=length(f)/300.;
   x=pow(x,3.)*.002;
   #endif
   x*=pow(eyeBrightnessSmooth.y/240.f,6.f);
   x=clamp(x,0.,.03);
   x/=saturate(s.y)*2.+1.;
   vec3 t=vec3(.2,.45,1.);
   v*=exp(-x*t*100.67);
   v+=AtmosphericScattering(normalize(s),worldSunVector,1.,x)*.9*mix(z,1.,.5)*mix(1.,.35,wetness)*.001;
 }
 void G(inout vec3 v,in vec3 f,in vec3 y,vec3 z,float s)
 {
   float r=length(f);
   r*=pow(eyeBrightnessSmooth.y/240.f,6.f);
   r*=rainStrength;
   float i=pow(exp(-r*1e-05),4.);
   i=max(i,.5);
   vec3 x=vec3(dot(colorSkyUp,vec3(1.)))*.05;
   v=mix(x,v,vec3(i));
 }
 vec4 B(float v,float f,vec3 s,vec3 y,vec3 z,vec3 x,vec3 r,float h,float c)
 {
   float o=1.;
   #ifdef SUNLIGHT_LEAK_FIX
   if(isEyeInWater<1)
     o=saturate(c*100.);
   #endif
   v=max(v-.05,0.);
   f=0.;
   float w=v*v,p=fract(frameCounter*.0123456);
   vec3 m=i(texcoord.xy).xyz*.99+.005,l=i(texcoord.xy+.1).xyz,a=reflect(r,G(m.xy,w,z));
   if(dot(a,z)<0.)
     a=reflect(a,z);
   #ifdef REFLECTION_SCREEN_SPACE_TRACING
   bool B=false;
   {
     const int k=32;
     vec2 b=texcoord.xy;
     vec3 R=y.xyz,T=normalize((gbufferModelView*vec4(a.xyz,0.)).xyz);
     float M=0.;
     vec3 D=y.xyz;
     float F=.05/saturate(dot(-r,z)+.001),P=F*2.,C=1.,U=0.;
     for(int S=0;S<k;S++)
       {
         float I=float(S),u=(I+.5)/float(k);
         vec3 H=T.xyz*F*(.1+length(D)*.1)*C;
         float Z=P*(length(D)*.1);
         D+=H;
         vec2 A=ProjectBack(D).xy;
         vec3 N=GetViewPosition(A.xy,GetDepth(A.xy)).xyz;
         float L=length(D)-length(N)-.02;
         if(D.z>0.)
           {
             break;
           }
         if(L>0.&&L<Z&&A.x>0.&&A.x<1.&&A.y>0.&&A.y<1.)
           {
             D-=H;
             C*=.5;
             U+=1.;
             if(U>2.)
               {
                 B=true;
                 b=A.xy;
                 R=N.xyz;
                 M=distance(D,y.xyz)*.4;
                 break;
               }
           }
       }
     vec3 N=(gbufferModelViewInverse*vec4(R,0.)).xyz;
     if(length(N)>far)
       B=false;
     if(B)
       {
         b.xy=floor(b.xy*vec2(viewWidth,viewHeight)+.5)/vec2(viewWidth,viewHeight);
         vec3 S=pow(texture2DLod(colortex3,b.xy,0).xyz,vec3(2.2)),I=S*100.;
         UnderwaterFog(I,length(N),a,colorSkyUp,colorSunlight);
         return vec4(I,saturate(M/4.));
       }
   }
   #endif
   int D=t(),I=e();
   vec3 S=s+z*(.001+h*.1);
   S+=Fract01(cameraPosition.xyz+.5);
   vec3 N=S;
   S=e(S,D);
   Ray b;
   b.origin=S*D-vec3(1.,1.,1.);
   b.dir=a;
   BBRay R=n(b.origin,b.dir);
   vec3 C=vec3(1.),U=vec3(0.);
   float M=0.,T=far;
   for(int F=0;F<1;F++)
     {
       vec3 P=vec3(floor(b.origin)),k=abs(vec3(length(b.dir))/(b.dir+.0001)),A=sign(b.dir),u=(sign(b.dir)*(P-b.origin)+sign(b.dir)*.5+.5)*k,H;
       vec4 L=vec4(0.);
       vec3 Z=vec3(0.);
       float E=.5;
       for(int O=0;O<REFLECTION_TRACE_LENGTH;O++)
         {
           Z=P/float(D);
           vec2 W=d(Z,D);
           L=texture2DLod(shadowcolor,W,0);
           M=L.w*255.;
           float V=1.-step(.5,abs(M-241.));
           vec3 X=L.xyz;
           float j=dot(P+.5-b.origin,P+.5-b.origin),Y=saturate(pow(saturate(dot(b.dir,normalize(P+.5-b.origin))),56.*j)*5.-1.)*5.;
           U+=X*V*E*.5*Y;
           if(M<240.&&O!=0)
             {
               break;
             }
           H=step(u.xyz,u.yzx)*step(u.xyz,u.zxy);
           u+=H*k;
           P+=H*A;
           E=1.;
         }
       if(L.w*255.<1.f||L.w*255.>254.f)
         {
           vec3 O=SkyShading(b.dir,worldSunVector,rainStrength);
           O=DoNightEyeAtNight(O*12.,timeMidnight)*.083333;
           O=TintUnderwaterDepth(O);
           U+=O*.1;
           T=1000.;
           break;
         }
       vec3 O=-(H*A),W[2]=vec3[2](P,P+1.);
       float Y,j;
       d(R,W,Y,j);
       T=Y;
       vec3 V=mod(b.origin+b.dir*Y,vec3(1.))-.5;
       vec2 X=vec2(0.);
       X+=vec2(V.z*A.x,-V.y)*H.x;
       X+=vec2(V.x,-V.z*A.y)*H.y;
       X+=vec2(-V.x*A.z,-V.y)*H.z;
       vec3 Q=(b.origin+b.dir*Y)/float(D);
       vec2 q=textureSize(colortex0,0);
       vec4 K=texture2DLod(shadowcolor1,d(Z,D),0);
       vec2 J=K.xy;
       J=(floor(J*q/TEXTURE_RESOLUTION)+.5)/(q/TEXTURE_RESOLUTION);
       vec2 ab=J+X.xy*(TEXTURE_RESOLUTION/q);
       vec3 ac=pow(texture2D(colortex0,ab).xyz,vec3(2.2));
       ac*=mix(vec3(1.),L.xyz/(K.w+1e-05),vec3(K.z));
       if(M<240.)
         {
           vec3 ad=saturate(L.xyz);
           C*=ac;
         }
       if(abs(M-31.)<.1)
         U+=.09*C*GI_LIGHT_BLOCK_INTENSITY;
       vec3 ae=vec3(0.),af=vec3(0.);
       if(abs(O.x)>.5)
         ae=vec3(0.,1.,0.),af=vec3(0.,0.,1.);
       if(abs(O.y)>.5)
         ae=vec3(1.,0.,0.),af=vec3(0.,0.,1.);
       if(abs(O.z)>.5)
         ae=vec3(1.,0.,0.),af=vec3(0.,1.,0.);
       ae*=1.;
       af*=1.;
       vec3 ag=g(Z,O),ah=ag,ai=saturate(ag*100000.),aj=g(Z+ae/float(D),O);
       ah+=aj;
       ai+=saturate(aj*100000.);
       vec3 ak=g(Z-ae/float(D),O);
       ah+=ak;
       ai+=saturate(ak*100000.);
       vec3 al=g(Z+af/float(D),O);
       ah+=al;
       ai+=saturate(al*100000.);
       vec3 am=g(Z-af/float(D),O);
       ah+=am;
       ai+=saturate(am*100000.);
       ah/=ai+vec3(.0001);
       U+=ah*1.5*C;
       const float an=2.4;
       vec3 ao=d(N+b.dir*Y-1.,worldLightVector,O,a,D)*C*an*colorSunlight*o;
       if(isEyeInWater>0)
         ;
       U+=ao;
     }
   vec3 O=normalize(y.xyz)*(length(y.xyz)+T),Z=(gbufferModelViewInverse*vec4(O.xyz,0.)).xyz;
   G(U,O,normalize(y.xyz),normalize(s.xyz),1.);
   UnderwaterFog(U,length(Z),r,colorSkyUp,colorSunlight);
   T*=saturate(dot(-r,z))*2.;
   return vec4(U,saturate(T/4.));
 }
 vec4 c(float v)
 {
   float f=v*v,y=f*v;
   vec4 r;
   r.x=-y+3*f-3*v+1;
   r.y=3*y-6*f+4;
   r.z=-3*y+3*f+3*v+1;
   r.w=y;
   return r/6.f;
 }
 vec4 c(in sampler2D v,in vec2 f)
 {
   vec2 y=vec2(viewWidth,viewHeight);
   f*=y;
   f-=.5;
   float s=fract(f.x),i=fract(f.y);
   f.x-=s;
   f.y-=i;
   vec4 r=c(s),z=c(i),a=vec4(f.x-.5,f.x+1.5,f.y-.5,f.y+1.5),x=vec4(r.x+r.y,r.z+r.w,z.x+z.y,z.z+z.w),d=a+vec4(r.y,r.w,z.y,z.w)/x,w=texture2DLod(v,vec2(d.x,d.z)/y,0),t=texture2DLod(v,vec2(d.y,d.z)/y,0),h=texture2DLod(v,vec2(d.x,d.w)/y,0),O=texture2DLod(v,vec2(d.y,d.w)/y,0);
   float D=x.x/(x.x+x.y),n=x.z/(x.z+x.w);
   return mix(mix(O,h,D),mix(t,w,D),n);
 }
 bool r(vec3 v,vec3 f)
 {
   vec3 s=normalize(cross(dFdx(v),dFdy(v))),y=normalize(f-v),i=normalize(y);
   return distance(v,f)<.05;
 }
 vec3 o(vec2 v)
 {
   vec2 f=vec2(viewWidth,viewHeight),i=1./f,s=v*f,y=floor(s-.5)+.5,x=s-y,z=x*x,a=x*z;
   float r=.5;
   vec2 d=-r*a+2.*r*z-r*x,t=(2.-r)*a-(3.-r)*z+1.,w=-(2.-r)*a+(3.-2.*r)*z+r*x,b=r*a-r*z,D=t+w,n=i*(y+w/D);
   vec3 c=texture2DLod(colortex4,vec2(n.x,n.y),0).xyz;
   vec2 O=i*(y-1.),A=i*(y+2.);
   vec4 o=vec4(texture2DLod(colortex4,vec2(n.x,O.y),0).xyz,1.)*(D.x*d.y)+vec4(texture2DLod(colortex4,vec2(O.x,n.y),0).xyz,1.)*(d.x*D.y)+vec4(c,1.)*(D.x*D.y)+vec4(texture2DLod(colortex4,vec2(A.x,n.y),0).xyz,1.)*(b.x*D.y)+vec4(texture2DLod(colortex4,vec2(n.x,A.y),0).xyz,1.)*(D.x*b.y);
   return max(vec3(0.),o.xyz*(1./o.w));
 }
 void main()
 {
   GBufferData v=GetGBufferData();
   GBufferDataTransparent f=GetGBufferDataTransparent();
   MaterialMask s=CalculateMasks(v.materialID),i=CalculateMasks(f.materialID);
   bool y=f.depth<v.depth;
   if(y)
     v.depth=f.depth,v.normal=f.normal,v.smoothness=f.smoothness,v.metalness=0.,v.mcLightmap=f.mcLightmap,i.sky=0.;
   vec4 r=GetViewPosition(texcoord.xy,v.depth),z=gbufferModelViewInverse*vec4(r.xyz,1.),d=gbufferModelViewInverse*vec4(r.xyz,0.);
   vec3 x=normalize(r.xyz),a=normalize(d.xyz),n=normalize((gbufferModelViewInverse*vec4(v.normal,0.)).xyz),w=normalize((gbufferModelViewInverse*vec4(v.geoNormal,0.)).xyz);
   float t=length(r.xyz);
   vec4 b=vec4(0.);
   float c=h(v.smoothness,v.metalness);
   if(c>.0001&&i.sky<.5)
     b=B(1.-v.smoothness,v.metalness,z.xyz,r.xyz,n.xyz,w,a.xyz,s.leaves,v.mcLightmap.y);
   vec4 m=texture2DLod(colortex3,texcoord.xy,0);
   vec3 O=m.xyz;
   O.xyz=pow(O.xyz,vec3(2.2));
   if(y)
     {
       vec3 D=GetViewPosition(texcoord.xy,texture2DLod(depthtex1,texcoord.xy,0).x).xyz;
       float p=length(D.xyz),U=p-t;
       vec3 o=f.normal-f.geoNormal*1.05;
       float C=saturate(U*.5);
       vec2 A=texcoord.xy+o.xy/(t+1.5)*C;
       O.xyz=pow(texture2DLod(colortex3,A.xy,0).xyz,vec3(2.2));
       D=GetViewPosition(A.xy,texture2DLod(depthtex1,A.xy,0).x).xyz;
       r=GetViewPosition(A.xy,texture2DLod(depthtex0,A.xy,0).x);
       p=length(D.xyz);
       t=length(r.xyz);
       U=p-t;
       if(i.water>.5&&isEyeInWater<1)
         {
           O.xyz*=exp(GetWaterAbsorption()*-U);
           vec3 Z=GetWaterFogColor()*.001;
           Z*=exp(-GetWaterAbsorption()*((-a.y*.5+.5)*3.));
           Z*=pow(curve(saturate(mix(a.y,1.,.5))),2.)*.6+.4;
           Z*=(colorSkyUp+colorSunlight*2.)*1.4;
           Z=TintUnderwaterDepth(Z);
           float N=exp(-U*.03);
           Z*=exp(-GetWaterAbsorption()*(1.-N)*20.);
           Z*=eyeBrightnessSmooth.y/240.;
           O=mix(Z,O,vec3(N));
         }
       if(i.stainedGlass>.5)
         {
           vec3 Z=normalize(f.albedo.xyz+.0001)*pow(length(f.albedo.xyz),.5);
           O.xyz*=mix(vec3(1.),Z,vec3(pow(f.albedo.w,.2)));
           O.xyz*=mix(vec3(1.),Z,vec3(pow(f.albedo.w,.2)));
         }
     }
   O.xyz=pow(O.xyz,vec3(1./2.2));
   b.xyz=saturate(b.xyz);
   gl_FragData[0]=texture2DLod(colortex0,texcoord.xy,0);
   gl_FragData[1]=vec4(O.xyz,v.smoothness);
   gl_FragData[2]=b;
 };




/* DRAWBUFFERS:036 */
